<x-app-layout>
    <!-- Hero Section -->
    <div class="relative bg-teal-50 overflow-hidden">
        <div class="max-w-7xl mx-auto">
            <div class="relative z-10 pb-8 bg-teal-50 sm:pb-16 md:pb-20 lg:max-w-2xl lg:w-full lg:pb-28 xl:pb-32">
                <main class="mt-10 mx-auto max-w-7xl px-4 sm:mt-12 sm:px-6 md:mt-16 lg:mt-20 lg:px-8 xl:mt-28">
                    <div class="sm:text-center lg:text-left">
                        <div class="inline-block px-3 py-1 rounded text-white text-xs font-bold tracking-wider mb-4 uppercase" style="background-color: #C0392B;">
                            🔥 Promo Terbatas Bulan Ini
                        </div>
                        <h1 class="text-4xl tracking-tight font-extrabold text-gray-900 sm:text-5xl md:text-6xl mb-6">
                            <span class="block">DP Ringan. Proses</span>
                            <span class="block">Cepat. <span class="text-blue-600 underline decoration-blue-200">Approval</span></span>
                            <span class="block text-blue-600 underline decoration-blue-200">Tinggi!</span>
                        </h1>
                        <p class="mt-3 text-base text-gray-500 sm:mt-5 sm:text-lg sm:max-w-xl sm:mx-auto md:mt-5 md:text-xl lg:mx-0 mb-8">
                            Wujudkan impian memiliki mobil baru untuk keluarga Anda hari ini. Data dibantu sampai approve, 99% pasti goal.
                        </p>
                        
                        <!-- Form Card (Left) -->
                        <div class="bg-white rounded-xl shadow-2xl p-6 border border-gray-100 max-w-md" x-data="leadForm()">
                            <div class="flex items-center gap-2 mb-4">
                                <span class="text-blue-600 text-xl">⚡</span>
                                <h3 class="text-lg font-bold text-gray-900">Dapatkan Simulasi Kredit</h3>
                            </div>
                            
                            <div class="space-y-3">
                                <input type="text" x-model="name" class="block w-full rounded-md border-gray-200 bg-gray-50 px-4 py-2 text-sm focus:border-blue-500 focus:ring-blue-500" placeholder="Nama Lengkap">
                                <input type="tel" x-model="phone" class="block w-full rounded-md border-gray-200 bg-gray-50 px-4 py-2 text-sm focus:border-blue-500 focus:ring-blue-500" placeholder="Nomor WhatsApp">
                                <div class="grid grid-cols-2 gap-3">
                                    <select x-model="city" class="block w-full rounded-md border-gray-200 bg-gray-50 px-2 py-2 text-sm focus:border-blue-500 focus:ring-blue-500">
                                        <option value="">Pilih Kota</option>
                                        <option value="Jakarta">Jakarta</option>
                                        <option value="Bogor">Bogor</option>
                                        <option value="Depok">Depok</option>
                                        <option value="Tangerang">Tangerang</option>
                                        <option value="Bekasi">Bekasi</option>
                                    </select>
                                    <select x-model="dp" class="block w-full rounded-md border-gray-200 bg-gray-50 px-2 py-2 text-sm focus:border-blue-500 focus:ring-blue-500">
                                        <option value="">Rencana DP</option>
                                        <option value="10-20 Juta">10 - 20 Juta</option>
                                        <option value="20-50 Juta">20 - 50 Juta</option>
                                        <option value="50 Juta+">Di atas 50 Juta</option>
                                    </select>
                                </div>
                                <button @click="submit()" class="w-full bg-blue-600 hover:bg-blue-700 text-white font-bold py-3 rounded-lg transition text-sm flex justify-center items-center gap-2">
                                    Minta Penawaran
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 5l7 7m0 0l-7 7m7-7H3"/></svg>
                                </button>
                            </div>
                        </div>
                    </div>
                </main>
            </div>
        </div>
        <div class="lg:absolute lg:inset-y-0 lg:right-0 lg:w-1/2 bg-teal-50 flex items-end justify-center">
            <img class="h-56 w-full object-cover sm:h-72 md:h-96 lg:w-full lg:h-full object-bottom" src="https://cdni.iconscout.com/illustration/premium/thumb/family-buying-new-car-2936998-2453676.png" alt="Happy Family with New Car">
        </div>
    </div>

    <!-- Countdown Section -->
    <div id="promo" class="bg-gray-50 border-b border-gray-200">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-6">
            <div class="flex flex-col md:flex-row items-center justify-between gap-6 text-center md:text-left">
                <div>
                    <h3 class="text-red-500 font-bold text-xl uppercase tracking-widest">Promo Berakhir Dalam</h3>
                    <p class="text-gray-500 text-sm mt-1">Jangan lewatkan kesempatan diskon hingga puluhan juta!</p>
                </div>
                
                <div class="flex gap-3" x-data="countdown()">
                    <template x-for="(value, label) in time" :key="label">
                        <div class="flex flex-col items-center">
                            <div class="bg-white rounded-lg shadow-sm border border-gray-200 w-16 h-16 flex items-center justify-center mb-1">
                                <span class="text-2xl font-bold text-gray-900" x-text="value"></span>
                            </div>
                            <span class="text-xs text-gray-500 font-medium uppercase" x-text="label"></span>
                        </div>
                    </template>
                </div>
            </div>
        </div>
    </div>

    <!-- USP Section -->
    <div class="py-12 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <!-- Card 1 -->
                <div class="flex items-start p-6 bg-white border border-gray-100 rounded-xl shadow-sm hover:shadow-md transition">
                    <div class="flex-shrink-0 p-3 bg-blue-50 rounded-lg">
                        <svg class="w-8 h-8 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                    </div>
                    <div class="ml-4">
                        <h3 class="text-lg font-bold text-gray-900">DP Mulai 5 Juta</h3>
                        <p class="mt-2 text-sm text-gray-600">Cicilan super ringan tenor panjang hingga 8 tahun. Bisa sesuaikan budget.</p>
                    </div>
                </div>

                <!-- Card 2 -->
                <div class="flex items-start p-6 bg-white border border-gray-100 rounded-xl shadow-sm hover:shadow-md transition">
                    <div class="flex-shrink-0 p-3 bg-blue-50 rounded-lg">
                        <svg class="w-8 h-8 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                    </div>
                    <div class="ml-4">
                        <h3 class="text-lg font-bold text-gray-900">Approval Mudah</h3>
                        <p class="mt-2 text-sm text-gray-600">Data kurang dibantu sampai goal. BI Checking dibantu cleasing.</p>
                    </div>
                </div>

                <!-- Card 3 -->
                <div class="flex items-start p-6 bg-white border border-gray-100 rounded-xl shadow-sm hover:shadow-md transition">
                    <div class="flex-shrink-0 p-3 bg-blue-50 rounded-lg">
                        <svg class="w-8 h-8 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path></svg>
                    </div>
                    <div class="ml-4">
                        <h3 class="text-lg font-bold text-gray-900">Bonus Melimpah</h3>
                        <p class="mt-2 text-sm text-gray-600">Free Asuransi, E-Toll, Kaca Film, dan Servis Berkala.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Best Seller Section -->
    <div id="katalog" class="bg-gray-50 py-16">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between items-end mb-10">
                <div>
                    <h2 class="text-3xl font-extrabold text-gray-900">Mobil Terlaris & Ready Stock</h2>
                    <p class="mt-2 text-gray-600">Pilih unit impianmu, proses cepat 1 hari kirim.</p>
                </div>
                <a href="{{ route('cars.index') }}" class="hidden md:inline-flex items-center text-blue-600 hover:text-blue-700 font-semibold">
                    Lihat Semua Stok
                    <svg class="ml-2 w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"></path></svg>
                </a>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                @forelse($featuredCars as $car)
                <div class="bg-white rounded-2xl shadow-sm hover:shadow-xl transition duration-300 overflow-hidden group">
                    <div class="relative px-6 pt-6 pb-2">
                        <div class="flex justify-between items-start mb-4">
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 text-red-800">
                                HOT DEAL
                            </span>
                        </div>
                        <div class="aspect-w-16 aspect-h-9 mb-4">
                            <img src="{{ $car->images[0] ?? 'https://via.placeholder.com/400x300' }}" alt="{{ $car->name }}" class="w-full h-48 object-contain object-center group-hover:scale-105 transition duration-500">
                        </div>
                    </div>
                    
                    <div class="px-6 pb-6">
                        <div class="flex items-center justify-between mb-2">
                            <div class="inline-flex items-center px-2 py-1 rounded text-xs font-medium bg-green-100 text-green-800">
                                <svg class="w-3 h-3 mr-1" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/></svg>
                                Ready Stock
                            </div>
                        </div>

                        <h3 class="text-lg font-bold text-gray-900">{{ $car->name }}</h3>
                        <p class="text-sm text-gray-500 mb-4">{{ $car->year }} &bull; {{ $car->brand->name }} &bull; {{ $car->type }}</p>

                        <div class="border-t border-gray-100 pt-4 mb-4">
                            <div class="flex justify-between items-center mb-1">
                                <span class="text-xs text-gray-500 uppercase tracking-wide">Mulai DP</span>
                                <span class="text-xs text-gray-500 uppercase tracking-wide">Angsuran</span>
                            </div>
                            <div class="flex justify-between items-center">
                                <span class="text-blue-600 font-bold text-lg">Rp {{ number_format($car->dp_min / 1000000, 1) }} Jt-an</span>
                                <span class="text-gray-900 font-bold">1.2 Jt-an</span>
                            </div>
                        </div>

                        <a href="https://wa.me/6281234567890?text=Halo%20saya%20tertarik%20{{ urlencode($car->name) }}" target="_blank" class="w-full flex items-center justify-center bg-green-500 hover:bg-green-600 text-white font-bold py-3 rounded-xl transition gap-2">
                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24"><path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.008-.57-.008-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413Z"/></svg>
                            Tanya Unit Ini
                        </a>
                    </div>
                </div>
                @empty
                <div class="col-span-3 text-center py-12">
                    <p class="text-gray-500 text-lg">Stok mobil sedang diperbarui...</p>
                </div>
                @endforelse
            </div>
            
            <div class="mt-8 text-center md:hidden">
                <a href="{{ route('cars.index') }}" class="inline-flex items-center text-blue-600 font-semibold">
                    Lihat Semua Stok
                    <svg class="ml-2 w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"></path></svg>
                </a>
            </div>
        </div>
    </div>

    <!-- Testimonials -->
    <div id="testimoni" class="py-16 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-12">
                <h2 class="text-3xl font-bold text-gray-900">Apa Kata Mereka?</h2>
                <p class="mt-4 text-gray-600">Ribuan keluarga Indonesia telah mempercayakan pembelian mobil barunya kepada kami.</p>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                <!-- Testimoni 1 -->
                <div class="bg-gray-50 p-8 rounded-2xl border border-gray-100 flex gap-4">
                    <img class="w-14 h-14 rounded-full object-cover" src="https://randomuser.me/api/portraits/men/42.jpg" alt="Pak Budi">
                    <div>
                        <div class="flex items-center justify-between mb-2">
                            <div>
                                <h4 class="font-bold text-gray-900">Pak Budi Santoso</h4>
                                <p class="text-xs text-gray-500">Wiraswasta, Jakarta</p>
                            </div>
                            <div class="flex text-yellow-400">
                                <svg class="w-4 h-4 fill-current" viewBox="0 0 20 20"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/></svg>
                                <svg class="w-4 h-4 fill-current" viewBox="0 0 20 20"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/></svg>
                                <svg class="w-4 h-4 fill-current" viewBox="0 0 20 20"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/></svg>
                                <svg class="w-4 h-4 fill-current" viewBox="0 0 20 20"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/></svg>
                                <svg class="w-4 h-4 fill-current" viewBox="0 0 20 20"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/></svg>
                            </div>
                        </div>
                        <p class="text-gray-600 italic">"Awalnya ragu karena data saya kurang bagus, tapi dibantu mas sales sampai approve. Prosesnya cepet banget cuma 3 hari mobil sudah sampai rumah. Mantap!"</p>
                    </div>
                </div>

                <!-- Testimoni 2 -->
                <div class="bg-gray-50 p-8 rounded-2xl border border-gray-100 flex gap-4">
                    <img class="w-14 h-14 rounded-full object-cover" src="https://randomuser.me/api/portraits/women/65.jpg" alt="Ibu Rina">
                    <div>
                        <div class="flex items-center justify-between mb-2">
                            <div>
                                <h4 class="font-bold text-gray-900">Ibu Rina Wijaya</h4>
                                <p class="text-xs text-gray-500">Karyawan Swasta, Bekasi</p>
                            </div>
                            <div class="flex text-yellow-400">
                                <svg class="w-4 h-4 fill-current" viewBox="0 0 20 20"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/></svg>
                                <svg class="w-4 h-4 fill-current" viewBox="0 0 20 20"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/></svg>
                                <svg class="w-4 h-4 fill-current" viewBox="0 0 20 20"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/></svg>
                                <svg class="w-4 h-4 fill-current" viewBox="0 0 20 20"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/></svg>
                                <svg class="w-4 h-4 fill-current" viewBox="0 0 20 20"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/></svg>
                            </div>
                        </div>
                        <p class="text-gray-600 italic">"Pelayanan sangat ramah dan transparan. Promo DP murahnya beneran, bukan gimmick doang. Sangat puas dengan pelayanan AutoDeal."</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- CTA Section -->
    <div class="bg-blue-600 py-16">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
            <h2 class="text-3xl font-extrabold text-white sm:text-4xl">Masih Bingung Pilih Mobil yang Mana?</h2>
            <p class="mt-4 text-xl text-blue-100">Konsultasikan kebutuhan dan budget Anda sekarang. Kami siap membantu 24/7 via WhatsApp.</p>
            <div class="mt-8">
                <a href="https://wa.me/6281234567890?text=Halo%20saya%20mau%20konsultasi%20mobil" target="_blank" class="inline-flex items-center justify-center px-8 py-4 border border-transparent text-lg font-bold rounded-lg text-blue-600 bg-white hover:bg-blue-50 transition transform hover:scale-105">
                    <svg class="w-6 h-6 mr-2" fill="currentColor" viewBox="0 0 24 24"><path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.008-.57-.008-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413Z"/></svg>
                    Hubungi Kami Sekarang
                </a>
            </div>
        </div>
    </div>

    <!-- Alpine Scripts -->
    <script>
        function leadForm() {
            return {
                name: '',
                phone: '',
                dp: '',
                city: '',
                submit() {
                    const message = `Halo, saya ingin minta simulasi kredit.\n\nNama: ${this.name}\nNo HP: ${this.phone}\nRencana DP: ${this.dp}\nDomisili: ${this.city}`;
                    const url = `https://wa.me/6281234567890?text=${encodeURIComponent(message)}`;
                    window.open(url, '_blank');
                }
            }
        }

        function countdown() {
            return {
                time: { Hari: '00', Jam: '00', Menit: '00', Detik: '00' },
                timer: null,
                expiry: new Date().setDate(new Date().getDate() + 2),
                init() {
                    this.timer = setInterval(() => {
                        const now = new Date().getTime();
                        const dist = this.expiry - now;
                        
                        this.time.Hari = String(Math.floor(dist / (1000 * 60 * 60 * 24))).padStart(2, '0');
                        this.time.Jam = String(Math.floor((dist % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60))).padStart(2, '0');
                        this.time.Menit = String(Math.floor((dist % (1000 * 60 * 60)) / (1000 * 60))).padStart(2, '0');
                        this.time.Detik = String(Math.floor((dist % (1000 * 60)) / 1000)).padStart(2, '0');
                    }, 1000);
                }
            }
        }
    </script>
</x-app-layout>
