<x-app-layout>
    <div class="bg-gray-100 min-h-screen py-12">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h1 class="text-3xl font-bold text-gray-900 mb-8">Katalog Mobil</h1>
            
            <div class="grid grid-cols-1 lg:grid-cols-4 gap-8">
                <!-- Sidebar Filters -->
                <div class="lg:col-span-1">
                    <div class="bg-white p-6 rounded-lg shadow-sm sticky top-24">
                        <h2 class="font-bold text-lg mb-4 cursor-pointer lg:cursor-default" @click="open = !open" x-data="{ open: true }">
                            Filter Pencarian
                            <span class="lg:hidden float-right" x-text="open ? '-' : '+'"></span>
                        </h2>
                        
                        <form action="{{ route('cars.index') }}" method="GET" class="space-y-4" x-show="open" x-transition>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Merek</label>
                                <select name="brand" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                    <option value="">Semua Merek</option>
                                    @foreach($brands as $brand)
                                        <option value="{{ $brand->id }}" {{ request('brand') == $brand->id ? 'selected' : '' }}>
                                            {{ $brand->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Rentang Harga</label>
                                <div class="grid grid-cols-2 gap-2">
                                    <input type="number" name="price_min" placeholder="Min" value="{{ request('price_min') }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 text-sm">
                                    <input type="number" name="price_max" placeholder="Max" value="{{ request('price_max') }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 text-sm">
                                </div>
                            </div>

                            <button type="submit" class="w-full bg-blue-600 text-white font-bold py-2 px-4 rounded hover:bg-blue-700 transition">
                                Terapkan Filter
                            </button>
                            <a href="{{ route('cars.index') }}" class="block w-full text-center text-sm text-gray-500 hover:text-gray-700 mt-2">
                                Reset Filter
                            </a>
                        </form>
                    </div>
                </div>

                <!-- Car Grid -->
                <div class="lg:col-span-3">
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                        @forelse($cars as $car)
                            <div class="bg-white rounded-lg shadow-md overflow-hidden hover:shadow-lg transition">
                                <div class="relative">
                                    <img src="{{ $car->images[0] ?? 'https://via.placeholder.com/400x300' }}" alt="{{ $car->name }}" class="w-full h-48 object-cover">
                                    <div class="absolute top-0 right-0 bg-blue-600 text-white px-3 py-1 rounded-bl-lg font-bold text-sm">
                                        DP {{ number_format($car->dp_min / 1000000, 1) }} Jt
                                    </div>
                                    @if($car->status == 'indent')
                                    <div class="absolute top-0 left-0 bg-yellow-500 text-white px-3 py-1 rounded-br-lg font-bold text-sm">
                                        INDENT
                                    </div>
                                    @endif
                                </div>
                                <div class="p-4">
                                    <h3 class="text-lg font-bold text-gray-900 mb-1">{{ $car->name }}</h3>
                                    <p class="text-gray-500 text-sm mb-3">{{ $car->brand->name }} &bull; {{ $car->year }}</p>
                                    <div class="flex items-end justify-between">
                                        <span class="text-blue-600 font-bold">Rp {{ number_format($car->price / 1000000, 0) }} Juta</span>
                                        <a href="{{ route('cars.show', $car->slug) }}" class="text-sm bg-gray-100 hover:bg-gray-200 text-gray-800 py-1 px-3 rounded transition">Detail</a>
                                    </div>
                                </div>
                            </div>
                        @empty
                            <div class="col-span-3 text-center py-12 bg-white rounded-lg shadow-sm">
                                <p class="text-gray-500 text-lg">Tidak ada mobil yang ditemukan dengan filter ini.</p>
                            </div>
                        @endforelse
                    </div>

                    <div class="mt-8">
                        {{ $cars->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
