<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('referrals', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('whatsapp')->unique();
            $table->string('referral_code')->unique();
            $table->integer('points')->default(0);
            $table->timestamps();
        });

        Schema::create('referral_points', function (Blueprint $table) {
            $table->id();
            $table->foreignId('referral_id')->constrained()->onDelete('cascade');
            $table->integer('points');
            $table->string('reason'); // e.g., 'Lead closing for Car X'
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('referral_points');
        Schema::dropIfExists('referrals');
    }
};
