<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('leads', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('whatsapp');
            $table->string('city')->nullable();
            $table->decimal('budget', 15, 2)->nullable();
            $table->text('message')->nullable();
            $table->foreignId('car_id')->nullable()->constrained()->nullOnDelete();
            $table->string('source')->default('form'); // calculator, form, wa_direct
            $table->enum('status', ['new', 'followed', 'negotiation', 'closing', 'lost'])->default('new');
            $table->string('referral_code')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('leads');
    }
};
