<?php

namespace App\Services;

class WhatsAppService
{
    public function generateLink($phone, $message = '')
    {
        // Format phone number to 628xxx
        $phone = preg_replace('/^0/', '62', $phone);
        $phone = preg_replace('/^\+62/', '62', $phone);
        
        $encodedMessage = urlencode($message);
        
        return "https://wa.me/{$phone}?text={$encodedMessage}";
    }

    public function generateCreditSimulationMessage($carName, $price, $dp, $tenor, $cicilan)
    {
        $message = "Halo, saya tertarik dengan kredit mobil berikut:\n\n";
        $message .= "Nama Mobil: {$carName}\n";
        $message .= "Harga: Rp " . number_format($price, 0, ',', '.') . "\n";
        $message .= "DP: Rp " . number_format($dp, 0, ',', '.') . "\n";
        $message .= "Tenor: {$tenor} Tahun\n";
        $message .= "Cicilan: Rp " . number_format($cicilan, 0, ',', '.') . "/bulan\n\n";
        $message .= "Mohon info lebih lanjut.";

        return $message;
    }
}
